/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.installationgroup;

import com.izforge.izpack.api.data.Pack;
import java.util.HashSet;
import java.util.Map;

public class GroupData {
    static final long ONEK = 1024L;
    static final long ONEM = 0x100000L;
    static final long ONEG = 0x40000000L;
    String name;
    String description;
    String sortKey;
    long size;
    HashSet<String> packNames = new HashSet();

    GroupData(String name, String description, String sortKey) {
        this.name = name;
        this.description = description;
        this.sortKey = sortKey;
    }

    String getSizeString() {
        String s = this.size < 1024L ? this.size + " bytes" : (this.size < 0x100000L ? this.size / 1024L + " KB" : (this.size < 0x40000000L ? this.size / 0x100000L + " MB" : this.size / 0x40000000L + " GB"));
        return s;
    }

    public void addDependents(Pack p, Map<String, Pack> packsByName) {
        this.packNames.add(p.getName());
        this.size += p.getSize();
        if (p.getDependencies() == null || p.getDependencies().size() == 0) {
            return;
        }
        for (String dependent : p.getDependencies()) {
            if (this.packNames.contains(dependent)) continue;
            Pack dependentPack = packsByName.get(dependent);
            this.addDependents(dependentPack, packsByName);
        }
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer("GroupData(");
        tmp.append(this.name);
        tmp.append("){description=");
        tmp.append(this.description);
        tmp.append(", sortKey=");
        tmp.append(this.sortKey);
        tmp.append(", size=");
        tmp.append(this.size);
        tmp.append(", sizeString=");
        tmp.append(this.getSizeString());
        tmp.append(", packNames=");
        tmp.append(this.packNames);
        tmp.append("}");
        return tmp.toString();
    }
}

